### Paper: QMSANet: A Quaternion Multi-Scale Attention Network for Color Image Denoising

## Requirements (Pytorch)  
#### Pytorch 2.0.0
#### Python 3.9
#### openCv for Python 4.90.0.80
#### HDF5 for Python  3.12.1
#### torchvision 0.15.0

## Commands
### Training
### 1. Datasets download
#### The  training dataset of the color noisy images is downloaded at https://pan.baidu.com/s/1TZUr-sUMWjswAC66aEYV0A?pwd=jbp4
#### The  testing datasets of the color noisy images are CBSD68, McMaster and Kodak24, which are already in the data folder.
#### ----> data
#### --------> CBSD68
#### --------> kodak
#### --------> McMaster
#### --------> pristine_images_color


### 2. Train QMSANet-S (QMSANet with known noise level)
```
python train.py --preprocess True --mode S --noiseL 25 --val_noiseL 25 --epochs 70
```
+ --preprocess: Select True if you need to regenerate the image block, otherwise select False.
+ --mode: S is the non-blind denoising model. 
+ --noiseL: Given noise level during training, 15, 25, 35, or 50.
+ --val_noiseL: Given noise level during validation, 15, 25, 35, or 50.


### 3. Test QMSANet-S (QMSANet with known noise level)
```
python test_S.py --logdir S50 --test_data kodak --test_noiseL 50
```
+ --logdir: The path of the results of our trained model (Denoising models for noise levels S15, S25, S35, S50 corresponding to noise levels 15, 25, 35, 50, respectively), S15, S25, S35, or S50.
+ --test_data: Test dataset (no noise), CBSD68, kodak, or McMaster.
+ --test_noiseL: Given noise level during testing, 15, 25, 35, or 50.


### 4. Train QMSANet-B (QMSANet with blind noise level)

```
python train.py --preprocess True --mode B --val_noiseL 25 --epochs 70
```
+ --preprocess: Select True if you need to regenerate the image block, otherwise select False.
+ --mode: B is the blind denoising model, the blind denoising model adds noise in the form of Gaussian noise with random standard deviation.
+ --val_noiseL: Given noise level during validation, 15, 25, 35, or 50.



### 5. Test QMSANet-B (QMSANet with blind noise level)
```
python test_S.py --logdir B25 --test_data kodak --test_noiseL 15
```
+ --logdir: The path of the results of our trained model, B25.
+ --test_data: Test dataset (no noise), CBSD68, kodak, or McMaster.
+ --test_noiseL: Any noise level in the range of [0, 55], generally selecting noise levels of 15, 25, 35, 50.



### 6. Demo (A script for processing a specific synthetic noise image)
```
python syn_demo.py --logdir S50 --single_image data/baby.png --test_noiseL 50
```
+ --logdir: The path of the results of our trained model, S15, S25, S35, S50 or B25 (B25 is the result of the pre-trained model with blind denoising).
+ --single_image: Single Image Path. For example, data/baby.png, data/CBSD68/14037.png, data/kodak/kodim15.png.
+ --test_noiseL: Given noise level during testing, 15, 25, 35, or 50 (Correspond to the selection of the logdir parameter).
# --logdir: S15  ——>  --test_noiseL: 15
# --logdir: S25  ——>  --test_noiseL: 25
# --logdir: S35  ——>  --test_noiseL: 35
# --logdir: S50  ——>  --test_noiseL: 50
# --logdir: B25  ——>  --test_noiseL: Any noise level in the range of [0, 55], generally selecting noise levels of 15, 25, 35, 50.



### 7.Output results
#### The output denoised image results are saved in the results folder.
#### The original synthesized noise image dataset is saved in the add_noise folder.
#### The original clean image dataset is saved in the data folder.


