### Paper: QMSANet: A Quaternion Multi-Scale Attention Network for Color Image Denoising

## Requirements (Pytorch)  
#### Pytorch 2.0.0
#### Python 3.9
#### openCv for Python 4.90.0.80
#### HDF5 for Python  3.12.1
#### torchvision 0.15.0

## Commands
### Training
### 1. Datasets download
#### The  training dataset of the color noisy images is downloaded at https://pan.baidu.com/s/1TZUr-sUMWjswAC66aEYV0A?pwd=jbp4
#### The  testing dataset of the color noisy images is cc, which is already in the data folder.
#### ----> data
#### --------> cc
#### --------> RealTrain


### 2. Train real denoising model QMSANet
```
python train_r.py --preprocess False --epochs 70 --test_data data/cc/cc --train_data data/RealTrain
```
+ --preprocess: Select True if you need to regenerate the image block, otherwise select False.
+ --test_data: Path to the validation dataset. 
+ --train_data: Path to the training dataset.


### 3. Test real denoising model QMSANet
```
python test_c.py --test_data data/cc/cc
```
+ --test_data: Path to the test dataset. 


### 4. Demo (A script for processing a specific real noise image)
```
python real_demo.py --test_image data/cc/cc/d800_iso1600_1_real.png
```
+ --test_image: Path to real noise image data, for example: data/cc/cc/d800_iso1600_1_real.png.
# The results will be saved in a new folder in the real_noisy file, for example: d800_iso1600_1_real_realdenoise folder.


### 5.Output results
### The output denoised image results are saved in the data/cc/cc_realdenoise folder.