# L1-Norm Redundant Delaunay Phase Unwrapping and Gradient Correcting

## Demo

The demo for the following method can be found [here](https://ipolcore.ipol.im/demo/clientApp/demo.html?id=77777000528).

## Code version

The code is currently (october 2024) in version 0.1. 

## Author info

- Alexandre Achard de Lustrac: alexandre.achard-de-lustrac@ens-paris-saclay.fr

- Roland Akiki: roland.akiki@ens-paris-saclay.fr

- Axel Davy: axel.davy@ens-paris-saclay.fr

- Jean-Michel Morel: moreljeanmichel@gmail.com

## Installation

In a python3.9 virtual environment that can be created for ex. with 
`python3.9 -m venv env`
and activated with 
`source env/bin/activate`
you can install `delaunay_unwrap` package via: 

```
cd phase_unwrap
pip install .["dev"] 
```

or if you want the exact version of packages that are on the IPOL demo, do 

```
cd phase_unwrap
pip install .["ipol"]
```

## Contributions

To contribute to the repository, please create a branch and perform a pull request. 

Before applying a commit, it is preferable to enforce style rules. To do so, install style requirements once in your environement `env` by running: 

`pip install -r style_requirements.txt`

Then to apply style rules to a file or directory run 

`bash phase_unwrap/style.sh <file or dir name>`

## License

We developped this code ourselves. The license attached is the BSD license in the repository. 

```
BSD 2-Clause License

Copyright (c) 2024, Centre Borelli
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
```

## Description

The code can perform either L1-Norm unwrapping (of wrapped values in the [-h, h) interval) or generic gradient correcting (also called integration). This method is based on the paper [1]



When in unwrapping mode, the goal is uwnwrapping values observed mod 2h. h can be arbitrary and given as input. The code takes as input as well the wrapped values, sampled on points that do not necessarily lie on a regular grid in the cartesian coordinate system. 

It constructs a graph via Delaunay triangulation and can add some redundant edges if the user wishes via keyword k. On this graph gradients are estimated and corrected to get a valid gradient field that sums up to zero on any cycle. When no redundancy is added, the solution can be found via a minimum cost flow optimization. Otherwise, a linear programming optimization is performed. 

The command to launch the demo on a raster that may contain nans (thus no regular sampling needed) is : 

` python phase_unwrap/run.py data/img.tif data/img.tif --k=<k> --h=<h> --b=<b> --useMCF=<true|false> --useSmallBasis=<true|false>
`

When `k=0` if `useMCF=true` the MCF algorithm will run, otherwise the linear program will run. To find cycles for the linear program optimization, if `useSmallBasis=true`, small cycles will be found because the graph is known to be a redundant Delaunay graph. Otherwise, a generic algorithm will run to find cycles that may be longer; 



When in integration mode, the goal is to correct an observed noisy gradient. The observed gradient taken as input is not a true gradient field, because it is not irrotational. The algorithm finds the nearest irrotational field in L1-Norm. The demo in integration mode will take an image (which might contain nans) as input. It will add noise to the actual gradients on the redundant Delaunay graph. Then, it will attempt to correct it.

To run a demo in integration mode

`python phase_unwrap/run.py data/img.tif data/img.tif --k=<k> --h=<h> --useMCF=<true|false> --useSmallBasis=<true|false> --integration_mode=true --prop=<prop> --intensity=<intensity> --sigma=<sigma> --use_weights=<use_weights>`



The file tree structure is as follows 

```
.
├── delaunay_unwrap  # delauny_unwrap package
│   ├── __init__.py
│   ├── integration_demo.py # code for the demo of integration
│   ├── linprog.py # code for the linear programming approach
│   ├── mcf.py # code for the minimum cost flow approach
│   ├── unwrap.py # calls either linprog and mcf
│   └── utils.py # common useful functions
├── dev_requirements.txt # requirements without fixed version number
├── LICENSE 
├── README.md
├── requirements.txt # requirements for the ipol packages
├── run.py # Run the demo, can be launched from cli
├── setup.py # setup script
├── style_requirements.txt # requirements for libs that format the code
├── style.sh # command to format the code
└── test_data.zip # test data that corresponds to the blobs

```

You can find the algorithms described in the paper in the following files

- linprog.py:
  
  - Algorithm 1
  
  - Algorithm 3
  
  - Algorithm 2
  
  - Algorithm 4

- mcf.py: 
  
  - Algorithm 5



[1] M. Costantini, F. Malvarosa, and F. Minati, “A general formulation for redundant integration of finite differences and phase unwrapping on a sparse multidimensional domain,” IEEE Trans. Geosci. Remote Sens., vol. 50, no. 3, pp. 758–768, 2012.