#!/usr/bin/env/python3

'''
    <A program precomputing polylog values for the IPOL demo "Thin-Plate Splines on the Sphere.">
    Copyright (C) 2022 Max Dunitz

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
'''

## this program evaluates the polylogarithms Li_2 and Li_3 at
## points uniformly spaced in [-1,1], and stores the result

import numpy as np
from mpmath import polylog, mpmathify, nstr

# points at which we wish to compute the polylogarithm
cs = np.linspace(-1,1,20000001)

# compute polylogarithms at the cs
precision = 15
plog3 = np.array([float(nstr(polylog(3,mpmathify(c)), precision, min_fixed=0, max_fixed=0)) for c in cs]) # for faster performance but less precision, use float(polylog(3,mpmathify(c)))
plog2 = np.array([float(nstr(polylog(2,mpmathify(c)), precision, min_fixed=0, max_fixed=0)) for c in cs]) # for faster performance but less precision, use float(polylog(2,mpmathify(c)))

# save results
np.save("plog3.npy", plog3)
np.save("plog2.npy", plog2)
