### TITLE

Image Segmentation using Backward Stochastic Differential Equations


### VERSION

1.0


### AUTHOR

Dariusz Borkowski <dbor@mat.umk.pl>


### CONTENTS

./BSDEseg.cpp - This program reads PNG images, runs the BSDE
	 method and writes PNG images. Only 8-bit (grayscale
	 and RGB) PNG images are handled.

./libdenoising.cpp, ./libdenoising.h - This source code implements
	the BSDE denoising algorithm.

./libsegmentation.cpp, ./libsegmentation.h - This source code implements
	the BSDE segmentation algorithm.

./lib.cpp, ./lib.h - Implementation of classes dbImageRGB
	and dbImage representing RGB and greyscale images, and
	operations on them.

./io_png.c, ./io_png.h - PNG read/write interface by Nicolas
	Limare <nicolas.limare@cmla.ens-cachan.fr>.

./input_images/BearAndGauss250.png, ./input_images/Bear.png,
./input_images/CoinAndGauss350.png, ./input_images/Coin.png,
./input_images/Cow.png, ./input_images/RoseGeraniumAndGauss150.png,
./input_images/RoseGeranium.png, ./input_images/ShamrockAndGauss500.png,
./input_images/Shamrock.png, ./input_images/Wrench.png
						- Test PNG images.

./input_med_images/ISIC_0024886.png, ./input_med_images/ISIC_0028999.png,
./input_med_images/ISIC_0024909.png, ./input_med_images/ISIC_0029230.png,
./input_med_images/ISIC_0027554.png
						- Medical PNG images.

The code is written in C/C++ and should compile on any system
with an g++ compiler.

The libpng header and libraries are required on the system for
compilation and execution.

The implementation uses OPENMP, which is not supported by old
versions of g++.


Ubuntu 22.04 LTS installation:

sudo apt install make
sudo apt install g++
sudo apt install libpng-dev


### COMPILATION INSTRUCTIONS

Simply use the provided makefile, with the command `make`.


### USAGE

usage: ./BSDEseg input.png mu segmented.png binarized.png region.png

BSDEseg takes 5 parameters:
* input.png 		: initial image (PNG image)
* mu			: the background parameter mu (non-negative
				real number). If the value exceeds the
				range [40, 99] then the value mu is
				determined automaticly by algorithm.
* segmented.png  	: output image as a result of the segmentation
				algorithm (PNG image)
* binarized.png  	: output image as a result of the binarization
				algorithm (PNG image)
* region.png  		: black-white output image with the central
				region of the segmentation (PNG image)

### EXAMPLES OF USE

Use the provided makefile, with the command `make tests`

The program first takes the input data input.png from the ./input_images/
directory with the parameter value mu=0 (automatic value). Then, images
from the ./input_med_images/ directory are processed with the parameter
value mu=40. The segmentation results are saved in the ./out_images/
and ./out_med_images/ directories.

### COPYRIGHT AND LICENSE INFORMATION

Copyright (c) 2023 Dariusz Borkowski

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public
License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
